/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import com.ibm.hwmca.fw.fcs.FcsServer;
import java.io.Serializable;

public class FcsServiceId
implements Serializable {
    static final long serialVersionUID = -3487047291637428150L;
    private static final String TRACE_MASKD = "XFCSSIDD";
    private static final String TRACE_MASKF = "XFCSSIDF";
    private static final String TRACE_MASKT = "XFCSSIDT";
    private String serviceName;
    private double version;
    private boolean temporaryServiceId;
    private static int internalUniqueId;

    public FcsServiceId() {
        this.version = 1.0;
        this.serviceName = "FCS" + FcsServer.getFcsServer().getLocalMachineId().hashCode() + internalUniqueId++;
        this.temporaryServiceId = true;
    }

    public FcsServiceId(String serviceName, double version) throws IllegalArgumentException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName passed to FcsServiceId can not be null");
        }
        if (version <= 0.0) {
            throw new IllegalArgumentException("version passed to FcsServiceId must be > 0");
        }
        this.serviceName = serviceName;
        this.version = version;
        this.temporaryServiceId = false;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public double getVersion() {
        return this.version;
    }

    public boolean isTemporaryServiceId() {
        return this.temporaryServiceId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof FcsServiceId && this.serviceName.equals(((FcsServiceId)obj).getServiceName()) && this.version == ((FcsServiceId)obj).getVersion();
    }

    public String toString() {
        return "[FcsServiceId: serviceName=" + this.serviceName + ", version=" + new Double(this.version).toString() + "]";
    }

    public int hashCode() {
        return this.serviceName.hashCode() + (int)this.version;
    }
}

